(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8038,        205]*)
(*NotebookOutlinePosition[      8878,        232]*)
(*  CellTagsIndexPosition[      8834,        228]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\( (*\ 
      Gauss\ quadrature\ with\ m = 12\ from\  - \[Pi]\ to\ \(\[Pi] . \)\ \ *) 
      \n (*\ \[Tau]_i = 
        \(\[Pi]\[Xi]_i\ \nNote\ that\ integral = 
          sum\ w_i\ f \((\[Xi]_i)\)\)\ \ *) \n\[Xi]1 = \(-0.9815606342\); \n
    \[Xi]2 = \(-0.9041172564\); \n\[Xi]3 = \(-0.7699026742\); \n
    \[Xi]4 = \(-0.5873179543\); \n\[Xi]5 = \(-0.3678314990\); \n
    \[Xi]6 = \(-0.1252334085\); \n\[Xi]7 = 0.1252334085; \n
    \[Xi]8 = 0.3678314990; \n\[Xi]9 = 0.5873179543; \n\[Xi]10 = 0.7699026742; 
    \n\[Xi]11 = 0.9041172564; \n\[Xi]12 = 0.9815606342; \nw1 = 0.0471753364; 
    \nw2 = 0.1069393260; \nw3 = 0.1600783285; \nw4 = 0.2031674267; \n
    w5 = 0.2334925365; \nw6 = 0.2491470458; \nw7 = 0.2491470458; \n
    w8 = 0.2334925365; \nw9 = 0.2031674267; \nw10 = 0.1600783285; \n
    w11 = 0.1069393260; \nw12 = 0.0471753364; \n
    f[t_, \[Tau]_]\  := \ 1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\); 
    \n (*\ \ The\ lhs\ of\ Eq\ \((1)\)\ \ *) \n
    \(y1 + \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Xi]1, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Xi]1, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Xi]1, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Xi]1, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Xi]1, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Xi]1, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Xi]1, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Xi]1, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Xi]1, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Xi]1, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Xi]1, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Xi]1, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify
      \)\)], "Input"],

Cell[BoxData[
    \(1.19685597977682389`\ y1 + 0.364343649250372392`\ y2 + 
      0.301510880540494952`\ y3 + 0.137271848791210215`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((2)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y2 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Xi]2, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Xi]2, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Xi]2, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Xi]2, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Xi]2, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Xi]2, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Xi]2, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Xi]2, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Xi]2, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Xi]2, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Xi]2, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Xi]2, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(0.202338101057919539`\ y1 + 1.36559210863727287`\ y2 + 
      0.297031243919526311`\ y3 + 0.135009322938545262`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((3)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y3 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Xi]3, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Xi]3, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Xi]3, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Xi]3, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Xi]3, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Xi]3, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Xi]3, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Xi]3, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Xi]3, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Xi]3, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Xi]3, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Xi]3, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(0.210800832064906806`\ y1 + 0.366781230461159868`\ y2 + 
      1.29055438484805474`\ y3 + 0.131836197958133616`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((4)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y4 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Xi]4, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Xi]4, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Xi]4, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Xi]4, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Xi]4, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Xi]4, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Xi]4, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Xi]4, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Xi]4, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Xi]4, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Xi]4, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Xi]4, \[Pi]\ \[Xi]12]\ )\) // N\) // Simplify\)], 
  "Input"],

Cell[BoxData[
    \(0.21902213515352451`\ y1 + 0.367263975839729184`\ y2 + 
      0.284698561893949921`\ y3 + 1.12903109589094174`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ to\ solve\ the\ four\ equations\ *) \n
    NSolve[{1.19685597977682389`\ y1 + 0.364343649250372392`\ y2 + 
            0.301510880540494952`\ y3 + 0.137271848791210215`\ y4 == \ 25, \n
        0.202338101057919539`\ y1 + 1.36559210863727287`\ y2 + 
            0.297031243919526311`\ y3 + 0.135009322938545262`\ y4 == \ 21, \n
        0.210800832064906806`\ y1 + 0.366781230461159868`\ y2 + 
            1.29055438484805474`\ y3 + 0.131836197958133616`\ y4 == \ 13, \n
        0.21902213515352451`\ y1 + 0.367263975839729184`\ y2 + 
            0.284698561893949921`\ y3 + 1.12903109589094174`\ y4 == \ 9}, 
      \ {y1, y2, y3, y4}]\n\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 16.2063759238289968`, y2 \[Rule] 12.1200143484799793`, 
        y3 \[Rule] 3.9939326417348191`, 
        y4 \[Rule] \(-0.122110537699084709`\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == 16.2063759238289968`, \n\t\t
        a0 + a1/2 - a2/2 - a3 == 12.1200143484799793`, \n\t\t
        a0 - a1/2 - a2/2 + a3 == 3.9939326417348191`, \n\t\t
        a0 - a1 + a2 - a3 == \ \(-0.122110537699084709`\)}, {a0, a1, a2, a3}]
      \)], "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.05202656109325332`, a1 \[Rule] 8.15152272275774691`, 
        a2 \[Rule] \(-0.00989386802829568878`\), 
        a3 \[Rule] 0.0127205080062940556`}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{44, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 1692, 30, 603, "Input"],
Cell[3426, 83, 149, 2, 26, "Output"]
}, Open  ]],
Cell[3590, 88, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3685, 93, 735, 15, 139, "Input"],
Cell[4423, 110, 149, 2, 26, "Output"]
}, Open  ]],
Cell[4587, 115, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4682, 120, 735, 15, 139, "Input"],
Cell[5420, 137, 149, 2, 26, "Output"]
}, Open  ]],
Cell[5584, 142, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[5679, 147, 735, 15, 139, "Input"],
Cell[6417, 164, 148, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6602, 171, 682, 10, 267, "Input"],
Cell[7287, 183, 191, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7515, 191, 308, 6, 107, "Input"],
Cell[7826, 199, 196, 3, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

